﻿using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Delete
{
    /// <summary>
    /// Get Service Appointment step.
    /// </summary>
    public class GetServiceAppointmentStep : FilterBase<VideoVisitDeleteStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitDeleteStateObject state)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                var appt = srv.AppointmentSet.FirstOrDefault(a => a.Id == state.AppointmentId);
                state.IsGroup = appt != null;
                if (state.IsGroup)
                {
                    state.CrmAppointment = appt;
                    if (state.CrmAppointment == null) throw new Exception(string.Format("Unable to retrieve Group Appointment - {0}", state.AppointmentId));
                    state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(sa => sa.Id == state.CrmAppointment.cvt_serviceactivityid.Id);
                    if (state.ServiceAppointment == null) throw new Exception(string.Format("Unable to retrieve Group Service Appointment - {0}", state.AppointmentId));
                }
                else
                {
                    state.ServiceAppointment = srv.ServiceAppointmentSet.FirstOrDefault(sa => sa.Id == state.AppointmentId);
                    if (state.ServiceAppointment == null) throw new Exception(string.Format("Unable to retrieve Individual Service Appointment - {0}", state.AppointmentId));

                }
            }
        }
    }
}